/* 
 * File:   bsp.h
 * Author: Jason Powell
 *
 * Created on 11 March 2016, 23:16
 */

#ifndef BSP_H
#define	BSP_H

#include <xc.h>

// DECLARATIONS ////////////////////////////////////////////////////////////////////////////
#define _XTAL_FREQ 500000                               //Used by the XC8 delay_ms(x) macro


// VDD ==                          PIN 11
// VSS ==                          PIN 12

// VDD ==                          PIN 32
// VSS ==                          PIN 31

// ICSP Clock                      PIN 39
// ICSP Data                       PIN 40



// PORT A
#define WIRELESS        RA0     // PIN 2 
#define OPTOCOUPLER     RA1     // PIN 3
#define EMSTOP          RA2     // PIN 4
#define MAGNET          RA3     // Pin 5
#define OSE             RA4     // Pin 6
//#define COM2             RA5     // Pin 7
//#define LEDSTRIP        RA6     // Pin 14
//#define DOWNSWITCH      RA7     // Pin 13

// PORT C
#define T1OSO           RC0     // Pin 15 XTAL OUTPUT
#define T1OSI           RC1     // Pin 16 XTAL INPUT
#define ALARM           RC2     // Pin 17
#define RELAY1          RC3     // Pin 18
#define RBUTTON         RC4     // Pin 23
#define MBUTTON         RC5     // Pin 24
#define LBUTTON         RC6     // Pin 25
#define EXTDOWN         RC7     // Pin 26 THE INPUT FROM

// PORT B
#define SEGA            RB0     // Pin 33
#define SEGB            RB1     // Pin 34
#define SEGC            RB2     // Pin 35
#define SEGD            RB3     // Pin 36
#define SEGE            RB4     // Pin 37
#define SEGF            RB5     // Pin 38
#define SEGG            RB6     // Pin 39
#define SEGDP           RB7     // Pin 40

// PORT D
#define RELAY2          RD0     // Pin 19
#define RELAY3          RD1     // Pin 20
#define LEARNRF         RD2     // Pin 21
#define SWITCHRF        RD3     // Pin 22
#define EXTUP           RD4     // Pin 27
#define PEC             RD5     // Pin 28
#define COM2            RD6     // Pin 29
#define COM1            RD7     // Pin 30

// PORT E
#define UPSWITCH        RE0     // Pin 8 - for 8K2 strip
#define STOPSWITCH      RE1     // Pin 9
#define DOWNSWITCH      RE2     // Pin 10 -
#define MCLR            RE3     // Pin 1


#define LOW             0
#define HIGH            1
#define NULL            0

//Time lengths for button presses up/down
#define COUNT_TARGET    2
#define COUNT_TARGET20  200
//Time lengths for getting out of 'Automatic' menu
#define COUNT_TARGET1   2500
#define COUNT_TARGET10  50000
//Time lengths for getting out of 'Adjustment' menu
#define COUNT_TARGET3   2500
#define COUNT_TARGET30  50000
//Time lengths for getting out of 'Input' menu
#define COUNT_TARGET4   2500
#define COUNT_TARGET40  50000
//Time lengths for getting out of 'Diagnosis' menu
#define COUNT_TARGET5   2500
#define COUNT_TARGET50  50000
//Time lengths for changing values, input menu, opening time
#define COUNT_TARGET6   2
#define COUNT_TARGET60  200


#define CAP_THRESHOLD   3 // THE DIFFERENCE BETWEEN UNTOUCHED CAP BUTTON, AND THE TOUCHED THRESHOLD
#define CAP_DEBOUNCE    2 //
#define EM_STOP         60 // ADC RETURN VALUE, OUT OF 255 OUT OF 5 VOLTS, FOR EM STOP NOT BEING LINKED

////END DECLARATIONS///////////////////////////////////////////////////////////////////////////////

#endif	/* BSP_H */

